/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.bin;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.bin.BinRecipe;
import mekanism.common.registries.MekanismRecipeSerializers;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BinInsertRecipe
extends BinRecipe {
    public BinInsertRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ItemStack binStack = ItemStack.f_41583_;
        ItemStack foundType = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_41720_() instanceof ItemBlockBin) {
                if (!binStack.m_41619_()) {
                    return false;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.m_41619_()) {
                foundType = stackInSlot;
                continue;
            }
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) continue;
            return false;
        }
        if (binStack.m_41619_() || foundType.m_41619_()) {
            return false;
        }
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        ItemStack remaining = slot.insertItem(foundType, Action.SIMULATE, AutomationType.MANUAL);
        return !ItemStack.m_41728_((ItemStack)remaining, (ItemStack)foundType);
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack binStack = ItemStack.f_41583_;
        ItemStack foundType = ItemStack.f_41583_;
        ArrayList<ItemStack> foundItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_41720_() instanceof ItemBlockBin) {
                if (!binStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.m_41619_()) {
                foundType = stackInSlot;
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) {
                return ItemStack.f_41583_;
            }
            foundItems.add(StackUtils.size(stackInSlot, 1));
        }
        if (binStack.m_41619_() || foundType.m_41619_()) {
            return ItemStack.f_41583_;
        }
        binStack = binStack.m_41777_();
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        boolean hasInserted = false;
        for (ItemStack stack : foundItems) {
            if (ItemStack.m_41728_((ItemStack)stack, (ItemStack)slot.insertItem(stack, Action.EXECUTE, AutomationType.MANUAL))) {
                if (hasInserted) break;
                return ItemStack.f_41583_;
            }
            hasInserted = true;
        }
        ItemDataUtils.setBoolean(binStack, "fromRecipe", true);
        return binStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remainingItems = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        ItemStack binStack = ItemStack.f_41583_;
        ItemStack foundType = ItemStack.f_41583_;
        IntArrayList foundSlots = new IntArrayList();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_41720_() instanceof ItemBlockBin) {
                if (!binStack.m_41619_()) {
                    return remainingItems;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.m_41619_()) {
                foundType = stackInSlot;
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) {
                return remainingItems;
            }
            foundSlots.add(i);
        }
        if (binStack.m_41619_() || foundType.m_41619_()) {
            return remainingItems;
        }
        binStack = binStack.m_41777_();
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        for (int i = 0; i < foundSlots.size(); ++i) {
            int index = foundSlots.getInt(i);
            ItemStack stack = StackUtils.size(inv.m_8020_(index), 1);
            ItemStack remaining = slot.insertItem(stack, Action.EXECUTE, AutomationType.MANUAL);
            remainingItems.set(index, (Object)remaining);
        }
        return remainingItems;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MekanismRecipeSerializers.BIN_INSERT.get();
    }

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        BinInventorySlot slot;
        ItemStack storedStack;
        ItemStack result = event.getCrafting();
        if (!result.m_41619_() && result.m_41720_() instanceof ItemBlockBin && ItemDataUtils.getBoolean(result, "fromRecipe") && !(storedStack = (slot = BinInsertRecipe.convertToSlot(result)).getStack()).m_41619_()) {
            Container craftingMatrix = event.getInventory();
            for (int i = 0; i < craftingMatrix.m_6643_(); ++i) {
                ItemStack stack = craftingMatrix.m_8020_(i);
                if (!(stack = StackUtils.size(stack, stack.m_41613_() - 1)).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)storedStack, (ItemStack)stack)) {
                    ItemStack remaining = slot.insertItem(stack, Action.EXECUTE, AutomationType.MANUAL);
                    craftingMatrix.m_6836_(i, remaining);
                    continue;
                }
                craftingMatrix.m_6836_(i, ItemStack.f_41583_);
            }
            ItemDataUtils.removeData(storedStack, "fromRecipe");
        }
    }
}

